<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class VerifyTokopayIP
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $allowedIps = ['178.128.104.179'];
        $requestIp = $request->ip();

        if (!in_array($requestIp, $allowedIps)) {
            return response()->json(['error' => 'Unauthorized IP Address'], 403);
        }

        return $next($request);
    }
}
